<nav x-data="{ 
        mobileOpen: false, 
        dropdownOpen: false,
        activeSection: 'home',
        
        // Fungsi Deteksi Scroll Otomatis
        detectScroll() {
            // Jika bukan di Homepage, tidak usah deteksi
            if (window.location.pathname !== '/') return; 
            
            // DAFTAR SECTION YANG DILACAK (Tambahkan portfolio & blog)
            const sections = ['home', 'about', 'services', 'portfolio', 'blog', 'contact'];
            
            for (const section of sections) {
                const el = document.getElementById(section);
                if (el) {
                    const rect = el.getBoundingClientRect();
                    // Logika: Jika elemen berada di area pandang (offset 100px dari atas)
                    if (rect.top <= 150 && rect.bottom >= 150) {
                        this.activeSection = section;
                    }
                }
            }
        }
    }" x-init="detectScroll()" @scroll.window="detectScroll()"
    class="bg-white shadow border-b border-gray-100 sticky top-0 z-50 transition-all duration-300">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-20">

            <div class="flex shrink-0 items-center">
                <a href="<?php echo e(route('home')); ?>" class="font-bold text-2xl text-blue-900 flex items-center gap-2">
                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2-2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                        </path>
                    </svg>
                    AskaTeknologi
                </a>
            </div>

            <div class="hidden sm:ml-6 sm:flex sm:items-center sm:space-x-8">

                
                <a href="<?php echo e(request()->routeIs('home') ? '#home' : route('home')); ?>" @click="activeSection = 'home'"
                    :class="activeSection === 'home' && '<?php echo e(request()->routeIs('home')); ?>' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                    class="inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition cursor-pointer">
                    Beranda
                </a>

                
                <a href="<?php echo e(request()->routeIs('home') ? '#about' : route('home') . '#about'); ?>"
                    @click="activeSection = 'about'"
                    :class="activeSection === 'about' && '<?php echo e(request()->routeIs('home')); ?>' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                    class="inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition cursor-pointer">
                    Tentang Kami
                </a>

                
                <a href="<?php echo e(request()->routeIs('home') ? '#services' : route('home') . '#services'); ?>"
                    @click="activeSection = 'services'"
                    :class="activeSection === 'services' && '<?php echo e(request()->routeIs('home')); ?>' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                    class="inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition cursor-pointer">
                    Layanan
                </a>

                
                <div class="relative inline-flex items-center pt-1" @click.outside="dropdownOpen = false">
                    <button @click="dropdownOpen = !dropdownOpen"
                        :class="(activeSection === 'portfolio' || activeSection === 'blog') && '<?php echo e(request()->routeIs('home')); ?>' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                        class="inline-flex items-center px-1 border-b-2 text-sm font-medium transition focus:outline-none h-full gap-1">
                        <span>Galeri & Info</span>
                        <svg class="w-4 h-4 transition-transform" :class="{'rotate-180': dropdownOpen}" fill="none"
                            stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7">
                            </path>
                        </svg>
                    </button>

                    <div x-show="dropdownOpen" style="display: none;" x-transition
                        class="absolute top-full left-0 mt-1 w-56 bg-white rounded-md shadow-lg ring-1 ring-black ring-opacity-5 py-2 z-50">

                        
                        <a href="<?php echo e(request()->routeIs('home') ? '#portfolio' : route('home') . '#portfolio'); ?>"
                            @click="dropdownOpen = false; activeSection = 'portfolio'"
                            class="block px-4 py-2 text-sm text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition">
                            <strong>Portofolio</strong>
                            <span class="block text-xs text-gray-400">Lihat hasil karya kami</span>
                        </a>

                        
                        <a href="<?php echo e(request()->routeIs('home') ? '#blog' : route('home') . '#blog'); ?>"
                            @click="dropdownOpen = false; activeSection = 'blog'"
                            class="block px-4 py-2 text-sm text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition">
                            <strong>Artikel & Berita</strong>
                            <span class="block text-xs text-gray-400">Update informasi terkini</span>
                        </a>
                    </div>
                </div>

                
                <div class="flex items-center pl-4">
                    <a href="<?php echo e(route('contact.page')); ?>" wire:navigate
                        class="px-6 py-2.5 bg-blue-600 text-white rounded-full font-bold text-sm hover:bg-blue-700 transition shadow-lg transform hover:-translate-y-0.5">
                        Kontak Kami
                    </a>
                </div>

            </div>

            <div class="-mr-2 flex items-center sm:hidden">
                <button @click="mobileOpen = ! mobileOpen"
                    class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': mobileOpen, 'inline-flex': ! mobileOpen }" class="inline-flex"
                            stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! mobileOpen, 'inline-flex': mobileOpen }" class="hidden"
                            stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <div :class="{'block': mobileOpen, 'hidden': ! mobileOpen}"
        class="hidden sm:hidden border-t border-gray-100 bg-white">
        <div class="pt-2 pb-4 space-y-1">
            <a href="<?php echo e(request()->routeIs('home') ? '#home' : route('home')); ?>"
                @click="mobileOpen = false; activeSection = 'home'"
                :class="activeSection === 'home' ? 'bg-blue-50 border-blue-500 text-blue-700' : 'border-transparent text-gray-500 hover:bg-gray-50 hover:border-gray-300 hover:text-gray-700'"
                class="block pl-3 pr-4 py-2 border-l-4 text-base font-medium transition">Beranda</a>

            <a href="<?php echo e(request()->routeIs('home') ? '#about' : route('home') . '#about'); ?>"
                @click="mobileOpen = false; activeSection = 'about'"
                :class="activeSection === 'about' ? 'bg-blue-50 border-blue-500 text-blue-700' : 'border-transparent text-gray-500 hover:bg-gray-50 hover:border-gray-300 hover:text-gray-700'"
                class="block pl-3 pr-4 py-2 border-l-4 text-base font-medium transition">Tentang Kami</a>

            <a href="<?php echo e(request()->routeIs('home') ? '#services' : route('home') . '#services'); ?>"
                @click="mobileOpen = false; activeSection = 'services'"
                :class="activeSection === 'services' ? 'bg-blue-50 border-blue-500 text-blue-700' : 'border-transparent text-gray-500 hover:bg-gray-50 hover:border-gray-300 hover:text-gray-700'"
                class="block pl-3 pr-4 py-2 border-l-4 text-base font-medium transition">Layanan</a>

            
            <div class="border-l-4 border-transparent">
                <span class="block pl-3 pr-4 py-2 text-xs font-bold text-gray-400 uppercase">Galeri & Info</span>

                
                <a href="<?php echo e(request()->routeIs('home') ? '#portfolio' : route('home') . '#portfolio'); ?>"
                    @click="mobileOpen = false; activeSection = 'portfolio'"
                    :class="activeSection === 'portfolio' ? 'text-blue-700 font-bold' : 'text-gray-600'"
                    class="block pl-8 pr-4 py-2 text-base font-medium hover:text-gray-800">Portofolio</a>

                
                <a href="<?php echo e(request()->routeIs('home') ? '#blog' : route('home') . '#blog'); ?>"
                    @click="mobileOpen = false; activeSection = 'blog'"
                    :class="activeSection === 'blog' ? 'text-blue-700 font-bold' : 'text-gray-600'"
                    class="block pl-8 pr-4 py-2 text-base font-medium hover:text-gray-800">Artikel & Berita</a>
            </div>

            
            <div class="pt-4 pb-2 px-4">
                <a href="<?php echo e(route('contact.page')); ?>" wire:navigate @click="mobileOpen = false"
                    class="block w-full text-center px-6 py-3 bg-blue-600 text-white rounded-lg font-bold text-sm hover:bg-blue-700 transition shadow-md">
                    Kontak Kami
                </a>
            </div>
        </div>
    </div>
</nav><?php /**PATH C:\laragon\www\company-profile\resources\views/livewire/components/navbar.blade.php ENDPATH**/ ?>