<style>
    /* Menyembunyikan scrollbar tapi tetap bisa discroll */
    .hide-scrollbar::-webkit-scrollbar {
        display: none;
    }

    .hide-scrollbar {
        -ms-overflow-style: none;
        scrollbar-width: none;
    }
</style>
<div>
    {{-- 1. HERO SECTION --}}
    <section id="home" class="relative bg-gray-900 text-white py-20 lg:py-28 overflow-hidden scroll-mt-20">
        <div class="absolute inset-0 bg-gradient-to-r from-blue-900 to-gray-900 opacity-90"></div>

        <div class="relative container mx-auto px-4 text-center z-10">
            <h1 class="text-4xl md:text-5xl font-bold mb-6 tracking-tight">
                {{ $hero?->company_name ?? 'Solusi Teknologi Terdepan' }}
            </h1>
            <p class="text-lg text-gray-300 mb-8 max-w-2xl mx-auto leading-relaxed">
                {{ $hero?->description ?? 'Mitra digital terbaik untuk transformasi bisnis Anda.' }}
            </p>
            <div class="flex flex-col sm:flex-row justify-center gap-4">
                <a href="#services"
                    class="px-8 py-3 bg-blue-600 hover:bg-blue-700 rounded-lg font-semibold transition shadow-lg text-white">
                    Jelajahi Layanan
                </a>
                <a href="{{ route('contact.page') }}"
                    class="px-8 py-3 bg-transparent border border-white hover:bg-white hover:text-gray-900 rounded-lg font-semibold transition text-white">
                    Hubungi Kami
                </a>
            </div>
        </div>
    </section>

    {{-- 2. TENTANG KAMI (UPDATE: Gambar Lebih Besar & Jelas) --}}
    <br>
    <section id="about" class="py-20 bg-white scroll-mt-20">
        <div class="container mx-auto px-4">
            <div class="flex flex-col lg:flex-row items-center gap-12 lg:gap-20"> {{-- Gap diperlebar di desktop --}}

                {{-- KOLOM KIRI: TEXT --}}
                <div class="lg:w-1/2">
                    <h2 class="text-blue-600 font-bold tracking-wide mb-2 md:text-3xl">Tentang Kami</h2>

                    {{-- Judul Dinamis --}}
                    <h3 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">
                        {{ $hero->about_title ?? 'Mitra Digital Terpercaya' }}
                    </h3>

                    {{-- Konten Dinamis --}}
                    <div class="prose text-gray-600 mb-6 leading-relaxed">
                        @if($hero->about_content)
                            {!! $hero->about_content !!}
                        @else
                            <p>Kami adalah perusahaan teknologi yang berdedikasi untuk membantu bisnis bertransformasi di
                                era digital.</p>
                            <p class="mt-4">Fokus kami adalah kepuasan klien dan kualitas kode yang handal.</p>
                        @endif
                    </div>
                </div>

                <div class="lg:w-1/2 w-full flex justify-center lg:justify-end">
                    <div
                        class="relative rounded-2xl overflow-hidden shadow-xl bg-gray-100 w-full h-80 lg:h-[400px] flex items-center justify-center border border-gray-200">

                        @if($hero->about_image)
                            <img src="{{ asset('storage/' . $hero->about_image) }}" alt="Tentang Kami"
                                class="w-full h-full object-cover">
                        @else
                            <div class="text-center p-10 text-gray-400">
                                <svg class="w-20 h-20 mx-auto mb-2 text-gray-300" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2-2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                                    </path>
                                </svg>
                                <span class="font-medium text-lg">Ilustrasi Perusahaan</span>
                            </div>
                        @endif

                    </div>
                </div>

            </div>
        </div>
    </section>

    {{-- 3. LAYANAN --}}
    <section id="services" class="py-20 bg-gray-50 scroll-mt-20">
        <div class="container mx-auto px-4">
            <div class="text-center mb-16">
                <h2 class="text-3xl font-bold text-gray-900 mb-4">Layanan Kami</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">Solusi komprehensif untuk kebutuhan teknologi Anda.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                @foreach($services as $service)
                    <div
                        class="bg-white p-8 rounded-xl shadow-sm hover:shadow-xl transition duration-300 border border-gray-100">
                        <div class="w-14 h-14 bg-blue-100 text-blue-600 rounded-lg flex items-center justify-center mb-6">
                            @if($service->icon)
                                <img src="{{ asset('storage/' . $service->icon) }}" class="w-8 h-8 object-contain">
                            @else
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                                </svg>
                            @endif
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">{{ $service->name }}</h3>
                        <p class="text-gray-600 mb-4 line-clamp-3 text-sm leading-relaxed">
                            {{ Str::limit(strip_tags($service->description), 100) }}
                        </p>
                    </div>
                @endforeach
            </div>

            <div class="text-center mt-16">
                <a href="{{ route('services') }}" wire:navigate
                    class="inline-flex items-center gap-2 px-8 py-3 bg-gray-900 text-white font-bold rounded-full hover:bg-blue-600 transition shadow-lg hover:shadow-blue-500/30 transform hover:-translate-y-1">
                    Lihat Semua Layanan
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M14 5l7 7m0 0l-7 7m7-7H3"></path>
                    </svg>
                </a>
            </div>
        </div>
    </section>

    {{-- 4. PORTOFOLIO (HORIZONTAL SCROLL / SLIDER) --}}
    <section id="portfolio" class="py-20 bg-white scroll-mt-15 border-t border-gray-50">

        {{-- Header (Judul & Tombol Panah Navigasi Visual) --}}
        <div class="container mx-auto px-4 mb-10 flex flex-col md:flex-row justify-between items-end gap-4">
            <div class="max-w-2xl">
                <h2 class="text-3xl font-bold text-gray-900 mb-2">Portofolio</h2>
                <p class="text-gray-600">Beberapa proyek yang telah kami selesaikan untuk klien dari berbagai industri.
                </p>
            </div>

            {{-- Indikator Geser (Hanya visual di Desktop) --}}
            <div class="hidden md:flex items-center gap-2 text-gray-400 text-sm font-medium">
                <span>Geser</span>
                <svg class="w-5 h-5 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3">
                    </path>
                </svg>
            </div>
        </div>

        {{-- CONTAINER SLIDER --}}
        {{--
        flex-nowrap: Memaksa satu baris
        overflow-x-auto: Mengaktifkan scroll horizontal
        snap-x: Efek magnet saat scroll berhenti
        hide-scrollbar: Class custom yang kita buat di atas
        --}}
        <div class="flex overflow-x-auto gap-6 px-4 pb-10 snap-x snap-mandatory hide-scrollbar w-full">

            @foreach($portfolios as $portfolio)
                {{-- CARD ITEM (Fixed Width) --}}
                {{-- w-80 (HP) dan w-[450px] (Laptop) agar gambar lebar dan jelas --}}
                <div class="flex-none w-80 md:w-[450px] snap-center group cursor-pointer">

                    {{-- 1. Gambar (Tanpa Border, Full Rounded) --}}
                    <div
                        class="relative h-64 md:h-[300px] rounded-2xl overflow-hidden shadow-md group-hover:shadow-2xl transition-all duration-500 ease-out">

                        @if($portfolio->image)
                            <img src="{{ asset('storage/' . $portfolio->image) }}" alt="{{ $portfolio->title }}"
                                class="w-full h-full object-cover transition duration-700 group-hover:scale-110">
                        @else
                            <div class="w-full h-full bg-gray-100 flex items-center justify-center text-gray-400">No Image</div>
                        @endif

                        {{-- Overlay Gradient Halus --}}
                        <div
                            class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-60 group-hover:opacity-40 transition">
                        </div>

                        {{-- Badge Kategori (Pojok Kiri Atas) --}}
                        <div class="absolute top-4 left-4">
                            <span
                                class="bg-white/90 backdrop-blur text-gray-900 text-xs font-bold px-3 py-1 rounded-full shadow-sm">
                                {{ $portfolio->category }}
                            </span>
                        </div>

                        {{-- Tombol Panah Bulat (Muncul saat Hover) --}}
                        <div
                            class="absolute bottom-4 right-4 bg-white text-black w-10 h-10 rounded-full flex items-center justify-center opacity-0 translate-y-4 group-hover:opacity-100 group-hover:translate-y-0 transition duration-300 shadow-lg">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M14 5l7 7m0 0l-7 7m7-7H3"></path>
                            </svg>
                        </div>
                    </div>

                    {{-- 2. Teks Info (Di luar gambar) --}}
                    <div class="mt-4 px-1">
                        <h3 class="text-xl font-bold text-gray-900 group-hover:text-blue-600 transition-colors">
                            {{ $portfolio->title }}
                        </h3>
                        <p class="text-gray-500 text-sm mt-1 line-clamp-1">
                            {{ Str::limit(strip_tags($portfolio->description), 80) }}
                        </p>
                    </div>

                </div>
            @endforeach

            {{-- CARD "LIHAT SEMUA" (Di Ujung Kanan) --}}
            <div class="flex-none w-48 snap-center flex items-center justify-center">
                <a href="{{ route('portfolio') }}" wire:navigate
                    class="group flex flex-col items-center gap-3 text-gray-400 hover:text-blue-600 transition p-6">
                    <div
                        class="w-16 h-16 rounded-full border-2 border-gray-200 group-hover:border-blue-600 flex items-center justify-center transition">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                        </svg>
                    </div>
                    <span class="font-bold text-sm uppercase tracking-wider">Lihat Semua</span>
                </a>
            </div>

        </div>
    </section>

    {{-- 5. ARTIKEL / BERITA (Updated: 3 Kolom) --}}
    <section id="blog" class="py-20 bg-gray-50 scroll-mt-20">
        <div class="container mx-auto px-4">
            <div class="flex justify-between items-end mb-10">
                <div>
                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900">Berita Terkini</h2>
                    <p class="text-gray-600 mt-2">Update dan informasi terbaru.</p>
                </div>
                <a href="{{ route('blog') }}" wire:navigate
                    class="inline-flex items-center gap-2 px-5 py-2.5 text-sm md:px-8 md:py-3 md:text-base bg-blue-600 text-white font-bold rounded-full hover:bg-gray-900 transition shadow-lg hover:shadow-gray-500/30 transform hover:-translate-y-1">
                    Lihat Blog
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M14 5l7 7m0 0l-7 7m7-7H3"></path>
                    </svg>
                </a>
            </div>

            {{-- GRID DIUBAH JADI 3 KOLOM (md:grid-cols-3) --}}
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                @foreach($articles as $article)
                    <div
                        class="group relative overflow-hidden rounded-xl shadow-lg cursor-pointer h-80 border border-gray-200">

                        @if($article->thumbnail)
                            <img src="{{ asset('storage/' . $article->thumbnail) }}"
                                class="w-full h-full object-cover transition duration-500 group-hover:scale-110">
                        @else
                            <div class="w-full h-full bg-gray-200 flex items-center justify-center text-gray-400">No Image</div>
                        @endif

                        <div
                            class="absolute inset-0 bg-gradient-to-t from-black/90 via-black/50 to-transparent flex flex-col justify-end p-8 transition duration-300">
                            <div class="text-blue-400 text-xs font-bold mb-2 flex items-center gap-2">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z">
                                    </path>
                                </svg>
                                {{ $article->created_at->format('d M Y') }}
                            </div>

                            <h3 class="text-white text-xl font-bold mb-2 group-hover:text-blue-400 transition line-clamp-2">
                                <a href="{{ route('blog.show', $article->slug) }}" wire:navigate>
                                    {{ $article->title }}
                                </a>
                            </h3>

                            <div
                                class="mt-2 opacity-0 transform translate-y-4 group-hover:opacity-100 group-hover:translate-y-0 transition duration-300">
                                <a href="{{ route('blog.show', $article->slug) }}" wire:navigate
                                    class="text-white font-medium inline-flex items-center gap-2 hover:text-blue-400 text-sm">
                                    Baca Selengkapnya &rarr;
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>

    {{-- 6. CONTACT --}}
    {{--
    FLOATING CONTACT SYSTEM (LOGIKA DIBALIK)
    Logic:
    1. isVisible = false (Default sembunyi).
    2. User gerak (resetTimer) -> isVisible = true (Muncul).
    3. Diam 3 detik -> isVisible = false (Sembunyi).
    --}}
    <div x-data="{ 
            isVisible: true, 
            showModal: false,
            timer: null,
            
            // Fungsi dijalankan saat ada aktivitas
            resetTimer() {
                this.isVisible = true; // User gerak -> TAMPILKAN tombol
                clearTimeout(this.timer);
                
                // Jika diam selama 3 detik, SEMBUNYIKAN tombol
                this.timer = setTimeout(() => {
                    // Jangan sembunyikan jika modal sedang dibuka
                    if (!this.showModal) {
                        this.isVisible = false; 
                    }
                }, 3000);
            }
         }" x-init="resetTimer()" @mousemove.window="resetTimer()" @scroll.window="resetTimer()"
        @click.window="resetTimer()" @keydown.window="resetTimer()" class="relative z-50">

        {{-- 1. TOMBOL CS (RESPONSIF: KECIL DI HP, BESAR DI LAPTOP) --}}
        <button @click="showModal = true" :class="isVisible ? 'translate-x-0 opacity-100' : 'translate-x-60 opacity-0'"
            class="fixed bottom-4 right-4 md:bottom-4 md:right-4 z-40 flex items-center gap-2 md:gap-3 px-3 py-2 md:px-5 md:py-3 bg-blue-600 text-white rounded-full shadow-2xl hover:bg-blue-700 transition-all duration-500 ease-in-out transform cursor-pointer border-2 border-white ring-2 ring-blue-200 group">
            <div class="flex flex-col items-start text-left mr-1">
                {{-- Teks lebih kecil di HP --}}
                <span class="text-[8px] md:text-[10px] uppercase font-bold text-blue-200 leading-tight">Butuh
                    Bantuan?</span>
                <span class="text-xs md:text-sm font-bold">Hubungi CS</span>
            </div>

            {{-- Icon lebih kecil di HP --}}
            <div class="bg-white text-blue-600 p-1.5 md:p-2 rounded-full animate-bounce-slow">
                <svg class="w-4 h-4 md:w-6 md:h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z">
                    </path>
                </svg>
            </div>
        </button>

        {{-- 2. MODAL POPUP CONTACT --}}
        <div x-show="showModal" style="display: none;" class="fixed inset-0 z-50 flex items-center justify-center px-4">
            {{-- Backdrop Gelap --}}
            <div @click="showModal = false" x-show="showModal" x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                x-transition:leave="transition ease-in duration-200" x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0" class="absolute inset-0 bg-gray-900/60 backdrop-blur-sm">
            </div>

            {{-- Konten Modal (VERSI COMPACT) --}}
            <div x-show="showModal" x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 scale-90 translate-y-10"
                x-transition:enter-end="opacity-100 scale-100 translate-y-0"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 scale-100 translate-y-0"
                x-transition:leave-end="opacity-0 scale-90 translate-y-10"
                class="relative bg-white rounded-xl shadow-2xl w-full max-w-lg border border-gray-100 overflow-hidden">
                {{-- Tombol Close (X) --}}
                <button @click="showModal = false"
                    class="absolute top-3 right-3 text-gray-400 hover:text-red-500 z-10 bg-gray-50 hover:bg-red-50 p-1.5 rounded-full transition">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                        </path>
                    </svg>
                </button>

                {{-- Embed Form --}}
                <div class="p-0">
                    <livewire:contact />
                </div>
            </div>
        </div>

    </div>
</div>