<div class="bg-white p-6 md:p-8">
    
    {{-- Header Kecil --}}
    <div class="text-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Kirim Pesan</h2>
        <p class="text-xs text-gray-500 mt-1">Kami akan membalas melalui email secepatnya.</p>
    </div>

    {{-- Alert Sukses (Kecil) --}}
    @if (session()->has('success'))
        <div class="bg-green-50 border border-green-200 text-green-700 px-3 py-2 rounded text-sm mb-4 text-center">
            {{ session('success') }}
        </div>
    @endif

    <form wire:submit="save" class="space-y-3"> {{-- Spasi antar input dirapatkan (space-y-3) --}}
        
        {{-- Baris 1: Nama & Email (Grid) --}}
        <div class="grid grid-cols-2 gap-3">
            <div>
                <input wire:model="name" type="text" placeholder="Nama Lengkap" class="w-full bg-gray-50 border border-gray-200 rounded-lg text-sm px-3 py-2.5 focus:ring-1 focus:ring-blue-500 focus:border-blue-500 outline-none transition">
                @error('name') <span class="text-red-500 text-[10px] block mt-1">{{ $message }}</span> @enderror
            </div>
            <div>
                <input wire:model="email" type="email" placeholder="Alamat Email" class="w-full bg-gray-50 border border-gray-200 rounded-lg text-sm px-3 py-2.5 focus:ring-1 focus:ring-blue-500 focus:border-blue-500 outline-none transition">
                @error('email') <span class="text-red-500 text-[10px] block mt-1">{{ $message }}</span> @enderror
            </div>
        </div>

        {{-- Baris 2: Subjek --}}
        <div>
            <input wire:model="subject" type="text" placeholder="Judul Pesan / Subjek" class="w-full bg-gray-50 border border-gray-200 rounded-lg text-sm px-3 py-2.5 focus:ring-1 focus:ring-blue-500 focus:border-blue-500 outline-none transition">
            @error('subject') <span class="text-red-500 text-[10px] block mt-1">{{ $message }}</span> @enderror
        </div>

        {{-- Baris 3: Pesan (Textarea diperpendek) --}}
        <div>
            <textarea wire:model="message" rows="3" placeholder="Tulis pesan Anda di sini..." class="w-full bg-gray-50 border border-gray-200 rounded-lg text-sm px-3 py-2.5 focus:ring-1 focus:ring-blue-500 focus:border-blue-500 outline-none transition resize-none"></textarea>
            @error('message') <span class="text-red-500 text-[10px] block mt-1">{{ $message }}</span> @enderror
        </div>

        {{-- Tombol Kirim --}}
        <button type="submit" class="w-full bg-blue-600 text-white font-bold py-2.5 rounded-lg hover:bg-blue-700 transition shadow-md text-sm flex justify-center items-center gap-2">
            <span>Kirim Sekarang</span>
            <svg wire:loading.remove class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path></svg>
            <svg wire:loading class="animate-spin w-4 h-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
        </button>
    </form>

    {{-- Footer Kecil Info Kontak --}}
    <div class="mt-4 pt-4 border-t border-gray-100 flex justify-center gap-6 text-gray-400">
        <div class="flex items-center gap-1 text-xs">
            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
            {{ $company->phone ?? '021-1234567' }}
        </div>
        <div class="flex items-center gap-1 text-xs">
            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
            {{ $company->email ?? 'info@company.com' }}
        </div>
    </div>
</div>