<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // 1. Tambah kolom tags ke tabel articles (tipe JSON agar bisa banyak tag)
        Schema::table('articles', function (Blueprint $table) {
            $table->json('tags')->nullable()->after('content'); 
        });

        // 2. Buat tabel comments
        Schema::create('comments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('article_id')->constrained('articles')->cascadeOnDelete();
            $table->string('name');
            $table->string('email');
            $table->text('content');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('comments');
        Schema::table('articles', function (Blueprint $table) {
            $table->dropColumn('tags');
        });
    }
};