<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('company_settings', function (Blueprint $table) {
        $table->string('about_title')->nullable()->after('description'); // Judul Section About
        $table->longText('about_content')->nullable()->after('about_title'); // Isi Text About
        $table->string('about_image')->nullable()->after('about_content'); // Gambar/Ilustrasi About
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('company_settings', function (Blueprint $table) {
        $table->dropColumn(['about_title', 'about_content', 'about_image']);
        });
    }
};
