<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
        $table->id();
        
        // Pastikan 3 baris ini ada:
        $table->string('name');        // <--- Ini yang menyebabkan error (Missing)
        $table->string('icon')->nullable(); // Untuk menyimpan path gambar
        $table->longText('description')->nullable(); // Gunakan longText untuk deskripsi panjang
        
        $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
