<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Article extends Model
{
    protected $guarded = [];

    // --- BAGIAN PENTING (Wajib Ada) ---
    protected $casts = [
        'tags' => 'array', // <--- Ini yang mengubah String jadi Array otomatis
        'is_published' => 'boolean',
    ];

    public function comments(): HasMany
    {
        return $this->hasMany(Comment::class)->latest();
    }
}