<?php

namespace App\Filament\Widgets;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use App\Models\Service;
use App\Models\Portfolio;
use App\Models\Article;
use App\Models\ContactMessage;

class StatsOverview extends BaseWidget
{
    // Atur agar widget ini reload otomatis setiap 15 detik (opsional)
    protected static ?string $pollingInterval = '15s';

    protected function getStats(): array
    {
        return [
            Stat::make('Total Layanan', Service::count())
                ->description('Layanan yang ditawarkan')
                ->descriptionIcon('heroicon-m-cube')
                ->color('primary'),

            Stat::make('Total Portofolio', Portfolio::count())
                ->description('Proyek terselesaikan')
                ->descriptionIcon('heroicon-m-camera')
                ->color('success'),

            Stat::make('Total Artikel', Article::where('is_published', true)->count())
                ->description('Artikel terbit')
                ->descriptionIcon('heroicon-m-newspaper')
                ->color('warning'),
            
            Stat::make('Pesan Masuk', ContactMessage::count())
                ->description('Inbox dari pengunjung')
                ->descriptionIcon('heroicon-m-envelope')
                ->color('danger'),
        ];
    }
}