<?php

namespace App\Filament\Widgets;

use Filament\Widgets\ChartWidget;
use App\Models\Article;
use Carbon\Carbon;

class ArticleChart extends ChartWidget
{
    protected static ?string $heading = 'Statistik Artikel Bulanan';
    
    // Urutan ke-5 (Kanan Bawah)
    protected static ?int $sort = 5; 

    // UKURAN DIKUNCI 300PX (Sama dengan grafik lainnya)
    protected static ?string $maxHeight = '300px';

    // Hapus columnSpan full agar dia hanya makan setengah layar (1 kolom)
    // protected int | string | array $columnSpan = 'full'; 

    protected function getData(): array
    {
        $data = Article::selectRaw('MONTH(created_at) as month, COUNT(*) as count')
            ->whereYear('created_at', date('Y'))
            ->groupBy('month')
            ->orderBy('month')
            ->pluck('count', 'month')
            ->toArray();

        $counts = [];
        for ($i = 1; $i <= 12; $i++) {
            $counts[] = $data[$i] ?? 0;
        }

        return [
            'datasets' => [
                [
                    'label' => 'Artikel Diterbitkan',
                    'data' => $counts,
                    'fill' => true,
                    'borderColor' => '#3b82f6',
                    'backgroundColor' => 'rgba(59, 130, 246, 0.1)',
                    'tension' => 0.4,
                ],
            ],
            'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'],
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }
    
    protected function getOptions(): array
    {
        return [
            // KUNCI AGAR KOTAK (1:1): Matikan aspect ratio bawaan
            'maintainAspectRatio' => false,
            
            'scales' => [
                'y' => [
                    'beginAtZero' => true,
                    'ticks' => [
                        'stepSize' => 1, 
                    ],
                ],
            ],
        ];
    }
}