<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CompanySettingResource\Pages;
use App\Models\CompanySetting;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

// Import komponen form
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\TextColumn;

class CompanySettingResource extends Resource
{
    protected static ?string $model = CompanySetting::class;

    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth'; // Icon Gear
    protected static ?string $navigationLabel = 'Pengaturan Web'; // Nama Menu
    protected static ?int $navigationSort = 100; // Taruh paling bawah

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                // SECTION 1: IDENTITAS (HERO) - Sudah ada sebelumnya
                Section::make('Identitas Utama (Hero Section)')
                    ->schema([
                        TextInput::make('company_name')
                            ->label('Nama Perusahaan')
                            ->required(),

                        Textarea::make('description')
                            ->label('Deskripsi Singkat Hero')
                            ->rows(3),
                    ]),

                // SECTION 2: TENTANG KAMI (BARU!)
                Section::make('Halaman Tentang Kami')
                    ->description('Data ini muncul di bagian "Tentang Kami" di bawah Hero.')
                    ->schema([
                        TextInput::make('about_title')
                            ->label('Judul Section')
                            ->placeholder('Contoh: Mitra Digital Terpercaya')
                            ->required(),

                        FileUpload::make('about_image')
                            ->label('Gambar Utama')
                            ->image() // Wajib file gambar
                            ->disk('public') // Simpan di folder public
                            ->directory('company') // Dalam folder portfolios
                            ->visibility('public') // Bisa dilihat umum
                            ->preserveFilenames(false) // Acak nama file (Mencegah error nama kembar)
                            ->imageEditor() // BONUS: Tambah fitur crop/edit gambar
                            ->required()
                            ->columnSpanFull(),

                        RichEditor::make('about_content')
                            ->label('Isi Konten')
                            ->columnSpanFull(),
                    ]),

                // SECTION 3: KONTAK (FOOTER) - Sudah ada sebelumnya
                Section::make('Kontak & Alamat')
                    ->schema([
                        TextInput::make('address')->label('Alamat Kantor'),
                        TextInput::make('email')->label('Email Resmi')->email(),
                        TextInput::make('phone')->label('No. Telepon'),
                        TextInput::make('instagram')->label('Instagram (Opsional)'),
                    ])->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('company_name')->label('Nama Perusahaan'),
                TextColumn::make('email')->label('Email'),
                TextColumn::make('phone')->label('Telepon'),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->paginated(false); // Matikan pagination karena cuma ada 1 data
    }

    // --- LOGIC PENTING: SINGLETON ---
    // Kita cek, jika sudah ada 1 data, jangan izinkan buat baru lagi.
    public static function canCreate(): bool
    {
        return CompanySetting::count() === 0;
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCompanySettings::route('/'),
            'create' => Pages\CreateCompanySetting::route('/create'),
            'edit' => Pages\EditCompanySetting::route('/{record}/edit'),
        ];
    }
}