<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CommentResource\Pages;
use App\Models\Comment;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Section;

class CommentResource extends Resource
{
    protected static ?string $model = Comment::class;

    protected static ?string $navigationIcon = 'heroicon-o-chat-bubble-left-right'; // Icon Chat
    protected static ?string $navigationLabel = 'Komentar Blog';
    protected static ?int $navigationSort = 3; // Urutan di bawah Artikel

    // Matikan tombol "New Comment" karena komentar hanya dari visitor
    public static function canCreate(): bool
    {
        return false;
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('Detail Komentar')
                    ->schema([
                        TextInput::make('name')
                            ->label('Nama Pengirim')
                            ->readOnly(), // Admin hanya baca
                        
                        TextInput::make('email')
                            ->label('Email')
                            ->email()
                            ->readOnly(),

                        TextInput::make('article.title') // Relasi ke Artikel
                            ->label('Pada Artikel')
                            ->readOnly(),

                        Textarea::make('content')
                            ->label('Isi Komentar')
                            ->rows(5)
                            ->columnSpanFull()
                            ->readOnly(),
                            
                        TextInput::make('created_at')
                            ->label('Waktu Kirim')
                            ->readOnly(),
                    ])->columns(2)
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label('Pengirim')
                    ->searchable()
                    ->sortable()
                    ->weight('bold'),

                TextColumn::make('email')
                    ->icon('heroicon-m-envelope')
                    ->copyable() // Bisa copy email dengan klik
                    ->color('gray'),

                TextColumn::make('content')
                    ->label('Komentar')
                    ->limit(50) // Batasi panjang teks di tabel
                    ->searchable(),

                TextColumn::make('article.title')
                    ->label('Artikel')
                    ->limit(30)
                    ->badge()
                    ->color('info'),

                TextColumn::make('created_at')
                    ->label('Tanggal')
                    ->dateTime('d M Y, H:i')
                    ->sortable(),
            ])
            ->defaultSort('created_at', 'desc') // Komentar terbaru di atas
            ->filters([
                // Bisa tambah filter by Article kalau mau (opsional)
            ])
            ->actions([
                Tables\Actions\ViewAction::make(), // Tombol Lihat Detail (Mata)
                Tables\Actions\DeleteAction::make(), // Tombol Hapus (Tong Sampah)
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(), // Hapus banyak sekaligus
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListComments::route('/'),
            // Kita hapus create & edit karena admin cuma butuh lihat/hapus
            // 'create' => Pages\CreateComment::route('/create'),
            // 'edit' => Pages\EditComment::route('/{record}/edit'),
        ];
    }
}