<div class="bg-gray-50 min-h-screen">
    
    {{-- 1. HEADER SECTION --}}
    <div class="bg-white shadow-sm py-12 border-b border-gray-200">
        <div class="container mx-auto px-4 text-center">
            <h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Layanan Kami</h1>
            <p class="text-gray-600 max-w-2xl mx-auto text-lg">
                Kami menyediakan solusi komprehensif yang disesuaikan dengan kebutuhan bisnis Anda untuk mencapai hasil maksimal.
            </p>
        </div>
    </div>

    {{-- 2. LIST SERVICES (GRID) --}}
    <div class="container mx-auto px-4 py-16">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            
            @forelse($services as $service)
                <div class="bg-white rounded-2xl shadow-md hover:shadow-xl transition-shadow duration-300 overflow-hidden border border-gray-100 flex flex-col h-full">
                    
                    {{-- Gambar / Icon Service --}}
                    <div class="h-48 overflow-hidden bg-gray-100 relative group">
                        @if($service->icon || $service->image)
                            {{-- Tampilkan Gambar jika ada --}}
                            <img src="{{ asset('storage/' . ($service->image ?? $service->icon)) }}" 
                                 alt="{{ $service->name }}" 
                                 class="w-full h-full object-cover transform group-hover:scale-105 transition duration-500">
                        @else
                            {{-- Fallback Placeholder --}}
                            <div class="w-full h-full flex items-center justify-center bg-blue-50">
                                <svg class="w-16 h-16 text-blue-200" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
                            </div>
                        @endif
                    </div>

                    {{-- Konten Card --}}
                    <div class="p-6 flex-grow flex flex-col">
                        <h3 class="text-xl font-bold text-gray-900 mb-3">{{ $service->name }}</h3>
                        
                        {{-- Deskripsi Singkat (Strip tags agar HTML editor tidak merusak card) --}}
                        <div class="text-gray-600 mb-4 flex-grow text-sm leading-relaxed">
                            {{ Str::limit(strip_tags($service->description), 150) }}
                        </div>

                        {{-- Tombol Detail (Optional: Bisa diarahkan ke halaman detail khusus layanan jika mau dibuatkan nanti, atau ke kontak) --}}
                        {{-- Untuk sekarang kita arahkan ke Contact saja --}}
                        <div class="mt-auto pt-4 border-t border-gray-100">
                             <a href="{{ route('portfolio') }}" class="text-blue-600 font-semibold text-sm hover:text-blue-800 flex items-center gap-1">
                                Lihat Portofolio Terkait
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
                            </a>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-span-full text-center py-20">
                    <div class="inline-block p-4 rounded-full bg-gray-100 mb-4">
                        <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path></svg>
                    </div>
                    <h3 class="text-lg font-medium text-gray-900">Belum ada layanan</h3>
                    <p class="text-gray-500 mt-1">Silakan tambahkan data layanan melalui Admin Panel.</p>
                </div>
            @endforelse

        </div>
    </div>

    {{-- 3. CTA SECTION (Call To Action) --}}
    <div class="bg-blue-900 text-white py-16">
        <div class="container mx-auto px-4 text-center">
            <h2 class="text-2xl md:text-3xl font-bold mb-4">Siap Memulai Proyek Anda?</h2>
            <p class="text-blue-200 mb-8 max-w-2xl mx-auto">
                Konsultasikan kebutuhan bisnis Anda dengan tim ahli kami. Kami siap memberikan solusi terbaik.
            </p>
            {{-- Pastikan route 'contact' nanti dibuat, atau ganti '#' sementara --}}
            <a href="{{ route('contact.page') }}" class="inline-block bg-white text-blue-900 font-bold px-8 py-3 rounded-lg hover:bg-gray-100 transition shadow-lg transform hover:-translate-y-1">
                Hubungi Kami Sekarang
            </a>
        </div>
    </div>

</div>