<div class="bg-white min-h-screen py-12">
    <div class="container mx-auto px-4">
        
        {{-- HEADER --}}
        <div class="text-center mb-12">
            <h1 class="text-4xl font-bold text-gray-900 mb-4">Portofolio Kami</h1>
            <p class="text-gray-600">Lihat bagaimana kami membantu klien mencapai tujuan mereka.</p>
        </div>

        {{-- FILTER BUTTONS --}}
        <div class="flex flex-wrap justify-center gap-4 mb-12">
            {{-- Tombol ALL --}}
            <button 
                wire:click="setCategory('All')"
                class="px-6 py-2 rounded-full border transition duration-300 
                {{ $activeCategory === 'All' 
                    ? 'bg-blue-600 text-white border-blue-600 shadow-lg' 
                    : 'bg-white text-gray-600 border-gray-300 hover:bg-gray-100' 
                }}">
                Semua Proyek
            </button>

            {{-- Tombol Kategori Dinamis --}}
            @foreach($categories as $category)
                <button 
                    wire:click="setCategory('{{ $category }}')"
                    class="px-6 py-2 rounded-full border transition duration-300 
                    {{ $activeCategory === $category 
                        ? 'bg-blue-600 text-white border-blue-600 shadow-lg' 
                        : 'bg-white text-gray-600 border-gray-300 hover:bg-gray-100' 
                    }}">
                    {{ $category }}
                </button>
            @endforeach
        </div>

        {{-- LOADING STATE (Optional: Efek loading saat ganti filter) --}}
        <div wire:loading class="w-full text-center py-12">
            <span class="text-blue-600 font-semibold animate-pulse">Memuat data...</span>
        </div>

        {{-- GRID PORTOFOLIO --}}
        <div wire:loading.remove class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @forelse($portfolios as $portfolio)
                <div class="group relative overflow-hidden rounded-xl shadow-lg cursor-pointer">
                    {{-- Gambar --}}
                    <img src="{{ asset('storage/' . $portfolio->image) }}" 
                         alt="{{ $portfolio->title }}" 
                         class="w-full h-80 object-cover transition duration-500 group-hover:scale-110">
                    
                    {{-- Overlay (Muncul saat Hover) --}}
                    <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/40 to-transparent opacity-0 group-hover:opacity-100 transition duration-300 flex flex-col justify-end p-6">
                        <span class="text-blue-400 text-sm font-bold uppercase tracking-wider mb-2">
                            {{ $portfolio->category }}
                        </span>
                        <h3 class="text-white text-2xl font-bold mb-1">{{ $portfolio->title }}</h3>
                        <p class="text-gray-300 text-sm">
                            {{ $portfolio->client ? 'Klien: ' . $portfolio->client : '' }}
                        </p>
                    </div>
                </div>
            @empty
                <div class="col-span-full text-center py-12">
                    <p class="text-gray-500 text-lg">Tidak ada proyek di kategori ini.</p>
                </div>
            @endforelse
        </div>

    </div>
</div>