<div class="bg-white min-h-screen pb-20">
    {{-- 1. HERO IMAGE --}}
    <div class="w-full h-[400px] relative bg-gray-900">
        @if($article->thumbnail)
            <img src="{{ asset('storage/' . $article->thumbnail) }}" alt="{{ $article->title }}"
                class="w-full h-full object-cover opacity-60">
        @else
            <div class="w-full h-full flex items-center justify-center text-gray-500 opacity-60">
                <span class="text-4xl font-bold">No Image</span>
            </div>
        @endif

        {{-- Overlay Title --}}
        <div class="absolute inset-0 flex items-center justify-center">
            <div class="container mx-auto px-4 text-center text-white">
                <span class="bg-blue-600 text-xs font-bold px-3 py-1 rounded-full uppercase tracking-wide">
                    {{ $article->category }}
                </span>
                <h1 class="text-3xl md:text-5xl font-bold mt-4 mb-2 leading-tight shadow-sm">
                    {{ $article->title }}
                </h1>
                <p class="text-gray-200 text-sm md:text-base">
                    Diposting pada {{ $article->created_at->format('d F Y') }}
                </p>
            </div>
        </div>
    </div>

    {{-- 2. KONTEN UTAMA --}}
    <div class="container mx-auto px-4 mt-[-50px] relative z-10">
        <div class="bg-white rounded-xl shadow-xl p-8 md:p-12 max-w-4xl mx-auto border border-gray-100">

            {{-- Breadcrumb / Back --}}
            <a href="{{ route('blog') }}"
                class="inline-flex items-center text-gray-500 hover:text-blue-600 mb-8 transition text-sm font-medium">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Kembali ke Blog
            </a>

            {{-- ARTICLE CONTENT --}}
            <article class="prose prose-lg max-w-none text-gray-700 prose-a:text-blue-600 prose-img:rounded-xl mb-10">
                {!! $article->content !!}
            </article>

            {{-- BAGIAN 1: TAGS & SHARE --}}
            <div
                class="flex flex-col md:flex-row justify-between items-start md:items-center border-t border-b border-gray-100 py-6 gap-6">

                {{-- Tags Section --}}
                <div class="flex items-center flex-wrap gap-2">
                    <span class="text-gray-500 font-bold flex items-center gap-1">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M21.41 11.58l-9-9C12.05 2.22 11.55 2 11 2H4c-1.1 0-2 .9-2 2v7c0 .55.22 1.05.59 1.42l9 9c.36.36.86.58 1.41.58.55 0 1.05-.22 1.41-.59l7-7c.37-.36.59-.86.59-1.41 0-.55-.23-1.06-.59-1.42zM5.5 7C4.67 7 4 6.33 4 5.5S4.67 4 5.5 4 7 4.67 7 5.5 6.33 7 5.5 7z" />
                        </svg>
                        Tags:
                    </span>

                    @php
                        $tagsData = $article->tags;
                        $finalTags = [];

                        // LOGIKA PENANGANAN FORMAT DATA
                        if (is_array($tagsData)) {
                            // Jika sudah array (format benar), pakai langsung
                            $finalTags = $tagsData;
                        } elseif (is_string($tagsData)) {
                            // JIKA STRING SEPERTI "malam,kenangan", PECAH JADI ARRAY
                            // Hilangkan tanda kutip atau kurung siku jika ada sisa JSON mentah
                            $cleanString = str_replace(['[', ']', '"'], '', $tagsData);
                            if (!empty($cleanString)) {
                                $finalTags = array_map('trim', explode(',', $cleanString));
                            }
                        }
                    @endphp

                    @if(count($finalTags) > 0)
                        @foreach($finalTags as $tag)
                            <span
                                class="px-3 py-1 bg-blue-50 text-blue-600 text-xs font-bold uppercase rounded hover:bg-blue-100 transition cursor-pointer">
                                {{ $tag }}
                            </span>
                        @endforeach
                    @else
                        <span class="text-gray-400 text-sm italic">Tidak ada tag</span>
                    @endif
                </div>

                {{-- Share Buttons --}}
                <div class="flex gap-2">
                    {{-- Instagram --}}
                    <a href="https://instagram.com" target="_blank"
                        class="flex items-center gap-2 px-4 py-2 bg-pink-600 text-white rounded-full text-sm font-bold hover:bg-pink-700 transition">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z" />
                        </svg>
                        Share
                    </a>
                    {{-- Facebook --}}
                    <a href="https://facebook.com" target="_blank"
                        class="flex items-center gap-2 px-4 py-2 bg-blue-800 text-white rounded-full text-sm font-bold hover:bg-blue-900 transition">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z" />
                        </svg>
                        Share
                    </a>
                    {{-- Whatsapp --}}
                    <a href="https://wa.me/?text={{ urlencode(url()->current()) }}" target="_blank"
                        class="flex items-center gap-2 px-4 py-2 bg-green-500 text-white rounded-full text-sm font-bold hover:bg-green-600 transition">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z" />
                        </svg>
                        Share
                    </a>
                </div>
            </div>

            {{-- BAGIAN 2: PREVIOUS & NEXT --}}
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-8 pb-8 border-b border-gray-100">
                {{-- Previous --}}
                <div class="text-left">
                    @if($prev)
                        <span class="text-gray-400 text-xs font-bold uppercase tracking-wider block mb-1">Previous
                            Article</span>
                        <a href="{{ route('blog.show', $prev->slug) }}" class="group flex items-center gap-3">
                            <div
                                class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center text-gray-400 group-hover:bg-blue-600 group-hover:text-white transition shrink-0">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 19l-7-7 7-7"></path>
                                </svg>
                            </div>
                            <span class="text-gray-700 font-bold group-hover:text-blue-600 transition line-clamp-2">
                                {{ $prev->title }}
                            </span>
                        </a>
                    @endif
                </div>

                {{-- Next --}}
                <div class="text-right flex flex-col items-end">
                    @if($next)
                        <span class="text-gray-400 text-xs font-bold uppercase tracking-wider block mb-1">Next
                            Article</span>
                        <a href="{{ route('blog.show', $next->slug) }}"
                            class="group flex items-center gap-3 flex-row-reverse text-right">
                            <div
                                class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center text-gray-400 group-hover:bg-blue-600 group-hover:text-white transition shrink-0">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                                    </path>
                                </svg>
                            </div>
                            <span class="text-gray-700 font-bold group-hover:text-blue-600 transition line-clamp-2">
                                {{ $next->title }}
                            </span>
                        </a>
                    @endif
                </div>
            </div>

            {{-- BAGIAN 3: KOMENTAR --}}
            <div class="mt-12">
                <h3 class="text-2xl font-bold text-gray-900 mb-2">Leave a Reply</h3>
                <p class="text-gray-500 text-sm mb-8 italic">Your email address will not be published. Required fields
                    are marked *</p>

                @if (session()->has('success'))
                    <div class="bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded mb-6">
                        {{ session('success') }}
                    </div>
                @endif

                <form wire:submit="saveComment" class="space-y-6">
                    <div>
                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Comment
                            *</label>
                        <textarea wire:model="comment_content" rows="5"
                            class="w-full bg-gray-100 border-gray-200 rounded focus:border-blue-500 focus:ring-blue-500 transition p-4"></textarea>
                        @error('comment_content') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Name
                                *</label>
                            <input wire:model="name" type="text"
                                class="w-full bg-gray-100 border-gray-200 rounded focus:border-blue-500 focus:ring-blue-500 transition p-3">
                            @error('name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Email
                                *</label>
                            <input wire:model="email" type="email"
                                class="w-full bg-gray-100 border-gray-200 rounded focus:border-blue-500 focus:ring-blue-500 transition p-3">
                            @error('email') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <button type="submit"
                        class="px-8 py-3 bg-gray-900 text-white font-bold uppercase tracking-wider text-xs rounded hover:bg-blue-600 transition">
                        Post Comment
                    </button>
                </form>

                {{-- List Komentar --}}
                @if($comments->count() > 0)
                    <div class="mt-16">
                        <h3 class="text-xl font-bold text-gray-900 mb-6">{{ $comments->count() }} Comments</h3>
                        <div class="space-y-8">
                            @foreach($comments as $comment)
                                <div class="flex gap-4">
                                    <div
                                        class="w-10 h-10 bg-gray-200 rounded-full flex items-center justify-center font-bold text-gray-500 shrink-0">
                                        {{ substr($comment->name, 0, 1) }}
                                    </div>
                                    <div>
                                        <h4 class="font-bold text-gray-900">{{ $comment->name }}</h4>
                                        <span
                                            class="text-xs text-gray-400">{{ $comment->created_at->format('d M Y, H:i') }}</span>
                                        <p class="text-gray-600 mt-2 text-sm">{{ $comment->content }}</p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>

        </div>
    </div>
</div>