<div class="bg-gray-50 min-h-screen">
    
    {{-- 1. HEADER SECTION (Hero Blog) --}}
    <div class="bg-gray-900 py-20 text-center relative overflow-hidden">
        {{-- Background accent --}}
        <div class="absolute inset-0 bg-gradient-to-b from-blue-900/50 to-gray-900 opacity-50"></div>
        
        <div class="relative container mx-auto px-4 z-10">
            <h1 class="text-4xl md:text-5xl font-bold text-white mb-4">Artikel & Wawasan</h1>
            <p class="text-gray-400 text-lg max-w-2xl mx-auto">
                Temukan berita terbaru, tips teknologi, dan update seputar layanan kami.
            </p>

            {{-- Search Bar Modern --}}
            <div class="mt-8 max-w-xl mx-auto relative">
                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                    <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                </div>
                <input 
                    wire:model.live.debounce.300ms="search" 
                    type="text" 
                    class="block w-full pl-11 pr-4 py-4 bg-gray-800 border-transparent text-white placeholder-gray-400 rounded-full focus:bg-gray-700 focus:border-blue-500 focus:ring-blue-500 transition shadow-lg" 
                    placeholder="Cari artikel..."
                >
            </div>
        </div>
    </div>

    {{-- 2. LIST ARTIKEL --}}
    <div class="container mx-auto px-4 py-16">
        
        {{-- Loading Indicator --}}
        <div wire:loading class="w-full text-center mb-8">
            <span class="inline-flex items-center gap-2 text-blue-600 font-semibold">
                <svg class="animate-spin h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                Mencari artikel...
            </span>
        </div>

        {{-- Grid Layout --}}
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @forelse($articles as $article)
                <article class="flex flex-col bg-white rounded-2xl overflow-hidden shadow-sm hover:shadow-xl transition duration-300 border border-gray-100 group h-full">
                    
                    {{-- Thumbnail Image --}}
                    <div class="relative h-56 overflow-hidden bg-gray-200">
                        @if($article->thumbnail)
                            <img src="{{ asset('storage/' . $article->thumbnail) }}" 
                                 alt="{{ $article->title }}" 
                                 class="w-full h-full object-cover transition duration-500 group-hover:scale-110">
                        @else
                            <div class="w-full h-full flex items-center justify-center text-gray-400">
                                <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                            </div>
                        @endif

                        {{-- Badge Kategori --}}
                        <div class="absolute top-4 left-4">
                            <span class="bg-blue-600 text-white text-xs font-bold px-3 py-1 rounded-full uppercase tracking-wide shadow-sm">
                                {{ $article->category }}
                            </span>
                        </div>
                    </div>

                    {{-- Content --}}
                    <div class="flex flex-col flex-grow p-6">
                        {{-- Tanggal --}}
                        <div class="flex items-center text-sm text-gray-500 mb-3">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                            {{ $article->created_at->format('d M Y') }}
                        </div>

                        {{-- Judul --}}
                        <h2 class="text-xl font-bold text-gray-900 mb-3 line-clamp-2 group-hover:text-blue-600 transition">
                            <a href="{{ route('blog.show', $article->slug) }}" wire:navigate>
                                {{ $article->title }}
                            </a>
                        </h2>

                        {{-- Excerpt / Cuplikan --}}
                        <p class="text-gray-600 text-sm mb-4 line-clamp-3 flex-grow leading-relaxed">
                            {{ Str::limit(strip_tags($article->content), 120) }}
                        </p>

                        {{-- Footer Card --}}
                        <div class="mt-auto pt-4 border-t border-gray-50 flex justify-between items-center">
                            <a href="{{ route('blog.show', $article->slug) }}" wire:navigate class="text-blue-600 font-semibold text-sm inline-flex items-center gap-1 hover:underline">
                                Baca Selengkapnya 
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
                            </a>
                        </div>
                    </div>
                </article>
            @empty
                <div class="col-span-full text-center py-20">
                    <div class="inline-block p-6 bg-white rounded-full shadow-sm mb-4">
                        <svg class="w-12 h-12 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path></svg>
                    </div>
                    <h3 class="text-lg font-medium text-gray-900">Tidak ada artikel ditemukan</h3>
                    <p class="text-gray-500 mt-1">Coba cari dengan kata kunci lain.</p>
                </div>
            @endforelse
        </div>

        {{-- Pagination --}}
        <div class="mt-12">
            {{ $articles->links() }}
        </div>
    </div>
</div>