@props(['title' => 'Company Profile']) {{-- Default title jika tidak ada kiriman --}}

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    {{-- Panggil props title di sini --}}
    <title>{{ $title }}</title>
    
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>html { scroll-behavior: smooth; }</style>
</head>
<body class="antialiased text-gray-800">
    {{-- Navbar --}}
    <livewire:components.navbar />

    <main>
        {{ $slot }}
    </main>

    {{-- Footer --}}
    <livewire:components.footer />
</body>
</html>