<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Service;
use Livewire\Attributes\Layout; // Kita pakai Attribute agar stabil

class ServiceIndex extends Component
{
    // Tentukan Layout di sini (agar tidak perlu x-layouts di view)
    #[Layout('components.layouts.app')] 
    public function render()
    {
        // Ambil semua layanan (bisa diganti paginate(9) jika layanan sangat banyak)
        $services = Service::all();

        return view('livewire.service-index', [
            'services' => $services,
            'title' => 'Layanan Profesional Kami - Company Profile',
        ]);
    }
}