<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Portfolio;
use Livewire\Attributes\Layout;

class PortfolioIndex extends Component
{
    // Properti untuk menyimpan filter yang sedang aktif
    // Default 'All' artinya tampilkan semua
    public $activeCategory = 'All';

    // Fungsi untuk mengubah filter (dipanggil saat tombol diklik)
    public function setCategory($category)
    {
        $this->activeCategory = $category;
    }

    #[Layout('components.layouts.app')]
    public function render()
    {
        // Ambil data. Jika filternya bukan 'All', tambahkan kondisi WHERE
        $portfolios = Portfolio::query()
            ->when($this->activeCategory !== 'All', function ($query) {
                $query->where('category', $this->activeCategory);
            })
            ->latest()
            ->get();

        // Ambil list kategori unik dari DB untuk membuat tombol filter otomatis
        $categories = Portfolio::select('category')->distinct()->pluck('category');

        return view('livewire.portfolio-index', [
            'portfolios' => $portfolios,
            'categories' => $categories,
            'title' => 'Hasil Karya Kami - Company Profile'
        ]);
    }
}