<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Service;
use App\Models\Portfolio;
use App\Models\Article;
use App\Models\CompanySetting;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Title;

class Home extends Component
{
    #[Title('Home - Company Profile')]
    #[Layout('components.layouts.app')] 
    public function render()
    {
        return view('livewire.home', [
            // Hero Section
            'hero' => CompanySetting::first(),
            
            // Layanan (Ambil 6)
            'services' => Service::take(6)->get(),
            
            // Portofolio (Ambil 6)
            'portfolios' => Portfolio::latest()->take(6)->get(),
            
            // ARTIKEL: UPDATE DI SINI (Ganti take(3) jadi take(2))
            'articles' => Article::where('is_published', true)
                        ->latest()
                        ->take(3) // <--- Hanya ambil 2 Artikel Terbaru
                        ->get(),
        ]);
    }
}