<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\ContactMessage;
use App\Models\CompanySetting;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Title;
use Livewire\Attributes\Rule;

class ContactPage extends Component
{
    #[Rule('required|min:3')]
    public $name = '';

    #[Rule('required|email')]
    public $email = '';

    #[Rule('required')]
    public $subject = '';

    #[Rule('required|min:10')]
    public $message = '';

    public function save()
    {
        $this->validate();

        ContactMessage::create([
            'name' => $this->name,
            'email' => $this->email,
            'subject' => $this->subject,
            'message' => $this->message,
        ]);

        $this->reset();
        session()->flash('success', 'Pesan Anda telah terkirim! Tim kami akan segera merespons.');
    }

    #[Title('Hubungi Kami - Company Profile')]
    #[Layout('components.layouts.app')]
    public function render()
    {
        return view('livewire.contact-page', [
            'company' => CompanySetting::first(),
        ]);
    }
}