<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\CompanySetting;
use App\Models\ContactMessage;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Rule; // Untuk validasi

class Contact extends Component
{
    #[Rule('required|min:3')]
    public $name = '';

    #[Rule('required|email')]
    public $email = '';

    #[Rule('required')]
    public $subject = '';

    #[Rule('required|min:10')]
    public $message = '';

    public function save()
    {
        $this->validate();

        // Simpan ke database
        ContactMessage::create([
            'name' => $this->name,
            'email' => $this->email,
            'subject' => $this->subject,
            'message' => $this->message,
        ]);

        // Reset form dan kirim pesan sukses
        $this->reset();
        session()->flash('success', 'Pesan Anda telah terkirim! Kami akan segera menghubungi Anda.');
    }

    #[Layout('components.layouts.app')]
    public function render()
    {
        return view('livewire.contact', [
            'company' => CompanySetting::first(),
            'title' => 'Hubungi Kami - Company Profile'
        ]);
    }
}