<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Article;
use App\Models\Comment;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Title;
use Livewire\Attributes\Rule;

class BlogShow extends Component
{
    public Article $article;
    
    // Properti untuk Form Komentar
    #[Rule('required|min:3')]
    public $name = '';

    #[Rule('required|email')]
    public $email = '';

    #[Rule('required|min:5')]
    public $comment_content = '';

    public function mount($slug)
    {
        $this->article = Article::where('slug', $slug)
            ->where('is_published', true)
            ->firstOrFail();
    }

    public function saveComment()
    {
        $this->validate();

        Comment::create([
            'article_id' => $this->article->id,
            'name' => $this->name,
            'email' => $this->email,
            'content' => $this->comment_content,
        ]);

        $this->reset(['name', 'email', 'comment_content']);
        session()->flash('success', 'Komentar Anda berhasil dikirim!');
    }

    #[Title('Blog Detail')] 
    #[Layout('components.layouts.app')] 
    public function render()
    {
        // Logic Previous & Next Post
        $prev = Article::where('id', '<', $this->article->id)->where('is_published', true)->orderBy('id', 'desc')->first();
        $next = Article::where('id', '>', $this->article->id)->where('is_published', true)->orderBy('id', 'asc')->first();

        return view('livewire.blog-show', [
            'prev' => $prev,
            'next' => $next,
            'comments' => $this->article->comments, // Ambil komentar artikel ini
            'title' => $this->article->title . ' - Company Profile'
        ]);
    }
}