<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Article;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Title;

class BlogIndex extends Component
{
    use WithPagination;

    public $search = '';
    
    // Reset halaman ke 1 jika user mengetik di search bar
    public function updatedSearch()
    {
        $this->resetPage();
    }

    #[Title('Blog & Berita - Company Profile')]
    #[Layout('components.layouts.app')] 
    public function render()
    {
        $articles = Article::query()
            ->where('is_published', true)
            ->where('title', 'like', '%'.$this->search.'%')
            ->latest()
            ->paginate(9); // Tampilkan 9 artikel per halaman

        return view('livewire.blog-index', [
            'articles' => $articles
        ]);
    }
}