<?php

namespace App\Filament\Widgets;

use Filament\Widgets\ChartWidget;
use App\Models\Service;
use Illuminate\Support\Facades\DB;

class ServiceChart extends ChartWidget
{
    protected static ?string $heading = 'Pertumbuhan Layanan';

    protected static ?int $sort = 3; // <--- GANTI JADI 3

    protected static ?string $maxHeight = '300px';

    protected function getData(): array
    {
        // Mengambil data layanan per bulan tahun ini
        $data = Service::selectRaw('MONTH(created_at) as month, COUNT(*) as count')
            ->whereYear('created_at', date('Y'))
            ->groupBy('month')
            ->orderBy('month')
            ->pluck('count', 'month')
            ->toArray();

        // Mapping ke 12 bulan (isi 0 jika kosong)
        $counts = [];
        for ($i = 1; $i <= 12; $i++) {
            $counts[] = $data[$i] ?? 0;
        }

        return [
            'datasets' => [
                [
                    'label' => 'Layanan Ditambahkan',
                    'data' => $counts,
                    'backgroundColor' => '#10b981', // Warna Hijau (agar beda dikit dari Inbox)
                    'borderRadius' => 4,
                ],
            ],
            'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'],
        ];
    }

    protected function getType(): string
    {
        return 'bar'; // Diagram Batang
    }
    
    protected function getOptions(): array
    {
        return [
            // KUNCI: Matikan aspect ratio agar tinggi mengikuti container
            'maintainAspectRatio' => false,
            
            'scales' => [
                'y' => [
                    'beginAtZero' => true,
                    'ticks' => [
                        'stepSize' => 1, 
                    ],
                ],
            ],
        ];
    }
}