<?php

namespace App\Filament\Widgets;

use Filament\Widgets\ChartWidget;
use App\Models\Portfolio;
use Illuminate\Support\Facades\DB;

class PortfolioChart extends ChartWidget
{
    protected static ?string $heading = 'Kategori Portofolio';

    protected static ?int $sort = 4; // <--- GANTI JADI 4
    
    protected static ?string $maxHeight = '300px';

    protected function getData(): array
    {
        // Mengambil jumlah portofolio berdasarkan kategori
        $data = Portfolio::select('category', DB::raw('count(*) as total'))
            ->groupBy('category')
            ->get();

        return [
            'datasets' => [
                [
                    'label' => 'Proyek',
                    'data' => $data->pluck('total'),
                    'backgroundColor' => [
                        '#3b82f6', // Biru
                        '#10b981', // Hijau
                        '#f59e0b', // Kuning
                        '#ef4444', // Merah
                        '#8b5cf6', // Ungu
                    ],
                ],
            ],
            'labels' => $data->pluck('category'),
        ];
    }

    protected function getType(): string
    {
        return 'doughnut'; // Tipe Diagram: Donat
    }
}