<?php

namespace App\Filament\Widgets;

use Filament\Widgets\ChartWidget;
use App\Models\ContactMessage;
use Illuminate\Support\Facades\DB;

class InboxChart extends ChartWidget
{
    protected static ?string $heading = 'Statistik Pesan Masuk';
    
    protected static ?int $sort = 2; // <--- PASTIKAN INI 2
    
    protected static ?string $maxHeight = '300px';

    protected function getData(): array
    {
        // Mengambil data pesan masuk per bulan tahun ini
        $data = ContactMessage::selectRaw('MONTH(created_at) as month, COUNT(*) as count')
            ->whereYear('created_at', date('Y'))
            ->groupBy('month')
            ->orderBy('month')
            ->pluck('count', 'month')
            ->toArray();

        // Mapping ke 12 bulan (isi 0 jika kosong)
        $counts = [];
        for ($i = 1; $i <= 12; $i++) {
            $counts[] = $data[$i] ?? 0;
        }

        return [
            'datasets' => [
                [
                    'label' => 'Pesan Diterima',
                    'data' => $counts,
                    'backgroundColor' => '#3b82f6', // Warna Biru
                    'borderRadius' => 4,
                ],
            ],
            'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'],
        ];
    }

    protected function getType(): string
    {
        return 'bar'; // Diagram Batang
    }
    
    protected function getOptions(): array
    {
        return [
            // PENTING: Matikan aspect ratio agar tinggi mau mengikuti maxHeight (300px)
            // Ini kunci agar ukurannya sama persis dengan grafik sebelah
            'maintainAspectRatio' => false,
            
            'scales' => [
                'y' => [
                    'beginAtZero' => true,
                    'ticks' => [
                        'stepSize' => 1, // Agar sumbu Y bilangan bulat (pesan tidak mungkin 1.5)
                    ],
                ],
            ],
        ];
    }
}