<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ContactMessageResource\Pages;
use App\Models\ContactMessage;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;

class ContactMessageResource extends Resource
{
    protected static ?string $model = ContactMessage::class;
    protected static ?string $navigationIcon = 'heroicon-o-inbox';
    protected static ?string $navigationLabel = 'Inbox Pesan';

    // Kita kosongkan form schema karena admin tidak menginput pesan
    public static function form(Form $form): Form
    {
        return $form->schema([]); 
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')->label('Nama Pengirim')->searchable(),
                TextColumn::make('email')->copyable(), // Bisa dicopy emailnya
                TextColumn::make('subject')->label('Subjek'),
                TextColumn::make('created_at')->dateTime()->label('Diterima'),
            ])
            ->actions([
                // Ganti Edit menjadi View (modal popup untuk baca pesan)
                Tables\Actions\ViewAction::make()
                    ->form([
                        Forms\Components\TextInput::make('name'),
                        Forms\Components\TextInput::make('email'),
                        Forms\Components\Textarea::make('message')->rows(10),
                    ]), 
                Tables\Actions\DeleteAction::make(),
            ])
            ->defaultSort('created_at', 'desc');
    }
    
    // Hapus tombol "New Contact Message" di pojok kanan atas
    public static function canCreate(): bool
    {
        return false;
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListContactMessages::route('/'),
        ];
    }
}